# model parameter values
wA = 0.6
wB = 1.6
delta = 0.3
x0 = 0.5
t_max = 10000

# vector to store population size over time
xs = numeric(t_max+1)
xs[1] = x0

# run the simulation
for ( t in 1:t_max )
  {
  w = ifelse(runif(1)<0.5,wA,wB)
  xs[t+1] = (1-delta)*xs[t] + delta*w*xs[t]/(w*xs[t]+1-xs[t])
  }

# draw the time series
plot(0:t_max,xs,type='l',pch=19,ylim=c(0,1),xlab='t',
     ylab='x')
x_bar_theory = (2-wA-wB)/(2*(1-wA)*(1-wB))
abline(h=x_bar_theory,lty=2)
